import random
from typing import List


def gen_input(n: int, q: int, e_range: int, c_range: int, t_range: int, v_range: int) -> str:
    e = [random.randint(1, e_range) for _ in range(n)]
    roads = []
    perm = random.sample(range(1, n + 1), n)
    for i in range(n - 1):
        (a, b) = (perm[i], perm[i + 1])
        c = random.randint(1, c_range)
        t = random.randint(1, t_range)
        roads.append((a, b, c, t))
    groups = [(random.randint(1, v_range), random.randint(1, n)) for _ in range(q)]
    input_str = f'{n} {q}\n'
    input_str += ' '.join(map(str, e)) + '\n'
    input_str += '\n'.join((' '.join(map(str, road)) for road in roads)) + '\n'
    input_str += '\n'.join((' '.join(map(str, group)) for group in groups))
    return input_str

def batch_gen_inputs(batch_size,) -> List[str]:
    inputs = []
    for _ in range(batch_size):
        input_str = gen_input(n=random.randint(2, 10), q=random.randint(1, 10), e_range=10, c_range=10, t_range=10, v_range=10)
        inputs.append(input_str)
    return inputs
