# TEST_RESULT: True
from itertools import permutations


def three_cycle_operation(arr, i, j, k):
    (arr[i], arr[j], arr[k]) = (arr[k], arr[i], arr[j])
    return arr

def is_sorted(arr):
    return all((arr[i] <= arr[i + 1] for i in range(len(arr) - 1)))

def solution(stdin: str) -> str:
    input_lines = stdin.strip().split('\n')
    num_tests = int(input_lines[0])
    output = []
    current_line = 1
    for t in range(num_tests):
        n = int(input_lines[current_line])
        arr = list(map(int, input_lines[current_line + 1].split()))
        current_line += 2
        if try_all_three_cycles(arr):
            output.append('YES')
        else:
            output.append('NO')
    return '\n'.join(output)

def try_all_three_cycles(arr, depth=0, max_depth=5):
    """
    Try all possible 3-cycle operations on the array recursively until it is sorted.
    The depth parameter is used to limit the recursion depth.
    """
    if is_sorted(arr):
        return True
    if depth >= max_depth:
        return False
    for indices in permutations(range(len(arr)), 3):
        (i, j, k) = indices
        temp_arr = arr.copy()
        three_cycle_operation(temp_arr, i, j, k)
        if try_all_three_cycles(temp_arr, depth + 1, max_depth):
            return True
    return False
