import random


def gen_input(max_n=10, max_m=20):
    n = random.randint(1, max_n)
    m = random.randint(0, min(max_m, n * (n - 1) // 2))
    comments = []
    for _ in range(m):
        (i, j) = random.sample(range(1, n + 1), 2)
        c = random.choice(['imposter', 'crewmate'])
        comments.append(f'{i} {j} {c}')
    return f'1\n{n} {m}\n' + '\n'.join(comments) + '\n'

def batch_gen_inputs(batch_size,):
    test_inputs = [gen_input(max_n=5, max_m=10) for _ in range(batch_size)]
    return test_inputs
