# TEST_RESULT: True
from itertools import product

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    k = int(lines[0])
    n = int(lines[1])
    colored_nodes = {}
    for i in range(n):
        (v, color) = lines[i + 2].split()
        colored_nodes[int(v)] = color
    colors = ['white', 'yellow', 'green', 'blue', 'red', 'orange']
    cube_adjacency = {'white': ['green', 'blue', 'red', 'orange'], 'yellow': ['green', 'blue', 'red', 'orange'], 'green': ['white', 'yellow', 'red', 'orange'], 'blue': ['white', 'yellow', 'red', 'orange'], 'red': ['white', 'yellow', 'green', 'blue'], 'orange': ['white', 'yellow', 'green', 'blue']}
    total_nodes = 2 ** k - 1
    valid_colorings = 0
    mod = 10 ** 9 + 7
    for coloring in product(colors, repeat=total_nodes):
        valid = True
        for (node, color) in colored_nodes.items():
            if coloring[node - 1] != color:
                valid = False
                break
        if not valid:
            continue
        for i in range(total_nodes):
            if i * 2 + 1 < total_nodes and coloring[i * 2 + 1] not in cube_adjacency[coloring[i]]:
                valid = False
                break
            if i * 2 + 2 < total_nodes and coloring[i * 2 + 2] not in cube_adjacency[coloring[i]]:
                valid = False
                break
        if valid:
            valid_colorings += 1
            if valid_colorings >= mod:
                valid_colorings -= mod
    return str(valid_colorings)
