import random
import numpy as np

def gen_input(t: int, max_n: int) -> str:
    """
    Function to generate test cases for the problem.
    It generates `t` test cases where for each test case,
    it generates a random integer `n` between 3 and `max_n`,
    and an array `a` of size `n` with each element being
    a random integer between 0 and 10^9.
    """
    assert 1 <= t <= 10 ** 4
    assert 3 <= max_n <= 2 * 10 ** 5
    test_cases = str(t) + '\n'
    for _ in range(t):
        n = random.randint(3, max_n)
        a = np.random.randint(0, 10 ** 9, n)
        test_cases += str(n) + '\n'
        test_cases += ' '.join(map(str, a)) + '\n'
    return test_cases

def batch_gen_inputs(batch_size,) -> list:
    """
    Function to generate a batch of test cases for the problem.
    It runs `gen_input` function 5 times with a small upper limit for `max_n`
    and returns a list of generated inputs.
    """
    inputs = []
    for _ in range(batch_size):
        inputs.append(gen_input(t=5, max_n=10))
    return inputs
