import random


def gen_input(t: int, n_min: int, n_max: int) -> str:
    input_str = str(t) + '\n'
    for _ in range(t):
        n = random.randint(n_min, n_max)
        input_str += str(n) + '\n'
        problems = []
        while len(problems) < n:
            a = random.randint(1, n)
            b = random.randint(1, n)
            if (a, b) not in problems:
                problems.append((a, b))
        for problem in problems:
            input_str += str(problem[0]) + ' ' + str(problem[1]) + '\n'
    return input_str

def batch_gen_inputs(batch_size,) -> list:
    inputs = []
    for _ in range(batch_size):
        inputs.append(gen_input(random.randint(1, 3), 3, 5))
    return inputs
