import random
import string

def gen_input(n: int) -> str:
    if not 1 <= n <= 20:
        raise ValueError('n must be between 1 and 20')
    sequences = []
    for _ in range(n):
        length = random.randint(1, 20000)
        sequence = ''.join((random.choice(['(', ')']) for _ in range(length)))
        sequences.append(sequence)
    result = f'{n}\n' + '\n'.join(sequences)
    return result

def batch_gen_inputs(batch_size,) -> list:
    inputs = []
    for _ in range(batch_size):
        n = random.randint(1, 10)
        test_case = gen_input(n)
        inputs.append(test_case)
    return inputs
