import random


def gen_input(n: int) -> str:
    weights = list(range(1, n + 1))
    random.shuffle(weights)
    s = ''.join((random.choice('LR') for _ in range(n)))
    input_str = f'{n}\n' + ' '.join((str(x) for x in weights)) + '\n' + s
    return input_str

def batch_gen_inputs(batch_size,) -> list[str]:
    inputs = []
    for _ in range(batch_size):
        n = random.randint(1, 10)
        inputs.append(gen_input(n))
    return inputs
