import random

def gen_input(T: int, N_max: int, A_max: int, B_max: int) -> str:
    test_cases = []
    for _ in range(T):
        N = random.randint(2, N_max)
        A = random.randint(0, min(A_max, N - 1))
        B = random.randint(0, min(B_max, N - 1))
        D_A = random.choice(['left', 'right'])
        D_B = random.choice(['left', 'right'])
        test_case = f'{N}\n{A} {B}\n{D_A} {D_B}'
        test_cases.append(test_case)
    return f'{T}\n' + '\n'.join(test_cases)

def batch_gen_inputs(batch_size,):
    inputs = []
    for _ in range(batch_size):
        inputs.append(gen_input(T=5, N_max=10, A_max=10, B_max=10))
    return inputs
