# TEST_RESULT: False
from typing import List, Tuple
from collections import defaultdict


def is_cactus(graph: List[Tuple[int, int]], n: int) -> bool:
    visited = [0] * (n + 1)
    cycle_edges = defaultdict(int)

    def dfs(node: int, parent: int) -> int:
        visited[node] = 1
        back_edges = 0
        for neighbor in graph[node]:
            if neighbor == parent:
                continue
            if visited[neighbor] == 0:
                back_edges += dfs(neighbor, node)
            else:
                back_edges += 1
        if back_edges > 1:
            cycle_edges[node] = back_edges
        return back_edges
    for node in range(1, n + 1):
        if visited[node] == 0:
            if dfs(node, -1) > 1:
                return False
    for (node, edges) in cycle_edges.items():
        if edges > 2:
            return False
    return True

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    (n, m) = map(int, lines[0].split())
    edges = [tuple(map(int, line.split())) for line in lines[1:]]
    counter = 0
    for l in range(m):
        for r in range(l, m):
            subgraph_edges = edges[l:r + 1]
            graph = defaultdict(list)
            for (u, v) in subgraph_edges:
                graph[u].append(v)
                graph[v].append(u)
            if is_cactus(graph, n):
                counter += 1
    return str(counter)
