# TEST_RESULT: True
from typing import List, Tuple


def is_clique(graph: List[List[int]], combination: List[int]) -> bool:
    for i in range(5):
        for j in range(i + 1, 5):
            if combination[j] not in graph[combination[i]]:
                return False
    return True

def is_independent_set(graph: List[List[int]], combination: List[int]) -> bool:
    for i in range(5):
        for j in range(i + 1, 5):
            if combination[j] in graph[combination[i]]:
                return False
    return True

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    (N, M) = map(int, lines[0].split())
    friendships = [list(map(int, line.split())) for line in lines[1:]]
    graph = [[] for _ in range(N + 1)]
    for (u, v) in friendships:
        graph[u].append(v)
        graph[v].append(u)
    for combination in itertools.combinations(range(1, N + 1), 5):
        if is_clique(graph, list(combination)) or is_independent_set(graph, list(combination)):
            return ' '.join(map(str, combination))
    return '-1'
