# TEST_RESULT: False

def generate_subarrays(arr):
    """Generates all nonempty subarrays of an array."""
    subarrays = []
    n = len(arr)
    for i in range(n):
        for j in range(i + 1, n + 1):
            subarrays.append(arr[i:j])
    return subarrays

def calculate_extreme_value(arr):
    """Calculates the extreme value of an array."""
    n = len(arr)
    operations = 0
    while not is_non_decreasing(arr):
        for i in range(n):
            if i < n - 1 and arr[i] > arr[i + 1]:
                (x, y) = divide_into_two(arr[i])
                arr = arr[:i] + [x, y] + arr[i + 1:]
                operations += 1
                break
    return operations

def is_non_decreasing(arr):
    """Checks if an array is non-decreasing."""
    return all((arr[i] <= arr[i + 1] for i in range(len(arr) - 1)))

def divide_into_two(n):
    """Divides a number into two positive integers."""
    return (n // 2, n - n // 2)

def brute_force_solution(t, test_cases):
    """Solves the problem using a brute force algorithm."""
    MOD = 998244353
    results = []
    for (n, arr) in test_cases:
        subarrays = generate_subarrays(arr)
        extreme_values = [calculate_extreme_value(subarray) for subarray in subarrays]
        results.append(sum(extreme_values) % MOD)
    return results
