import random

def gen_input(num_cases: int, max_val: int) -> str:
    inputs = []
    inputs.append(str(num_cases))
    for _ in range(num_cases):
        x_0 = random.randint(-max_val, max_val)
        n = random.randint(0, max_val)
        inputs.append(f'{x_0} {n}')
    return '\n'.join(inputs)

def batch_gen_inputs(batch_size,) -> list:
    batch_inputs = []
    for _ in range(batch_size):
        num_cases = random.randint(1, 5)
        max_val = random.randint(1, 10)
        batch_inputs.append(gen_input(num_cases, max_val))
    return batch_inputs
