import random


def gen_input(max_t: int, max_n: int, max_val: int) -> str:
    t = random.randint(1, max_t)
    inputs = [str(t)]
    for _ in range(t):
        n = random.randint(2, max_n)
        sequence = random.sample(range(1, min(n, max_val) + 1), n)
        inputs.append(str(n))
        inputs.append(' '.join(map(str, sequence)))
    return '\n'.join(inputs)

def batch_gen_inputs(batch_size,) -> list[str]:
    inputs = []
    for _ in range(batch_size):
        inputs.append(gen_input(4, 5, 10))
    return inputs
