import random


def gen_input(n):
    vertices = set(range(1, n + 1))
    root = 1
    edges = []
    for new_vertex in range(2, n + 1):
        existing_vertex = random.choice(list(vertices - {new_vertex}))
        edges.append((existing_vertex, new_vertex))
    input_string = str(n) + '\n'
    for edge in edges:
        input_string += f'{edge[0]} {edge[1]}\n'
    return input_string

def batch_gen_inputs(batch_size,):
    batch_inputs = []
    n_list = [2, 3, 4, 5, 6, 7, 8, 9]
    for _ in range(batch_size):
        batch_inputs.append(gen_input(random.choice(n_list)))
    return batch_inputs
