import random


def gen_input(max_t=2, max_n=5, max_m=5):
    t = random.randint(1, max_t)
    input_str = str(t) + '\n'
    for _ in range(t):
        n = random.randint(2, max_n)
        m = random.randint(1, min(n, max_m))
        nodes = list(range(1, n + 1))
        random.shuffle(nodes)
        edges = [(nodes[i - 1], nodes[i], random.randint(-1, 2 ** 30 - 1) if random.random() < 0.5 else -1) for i in range(1, n)]
        elves = [(random.randint(1, n), random.randint(1, n), random.randint(0, 1)) for _ in range(m)]
        input_str += f'{n} {m}\n'
        input_str += '\n'.join((f'{x} {y} {v}' for (x, y, v) in edges)) + '\n'
        input_str += '\n'.join((f'{a} {b} {p}' for (a, b, p) in elves)) + '\n'
    return input_str

def batch_gen_inputs(batch_size,):
    return [gen_input() for _ in range(batch_size)]
