import random


def gen_input(t: int, n: int) -> str:
    inputs = []
    for _ in range(t):
        num_towns = random.randint(1, n)
        inputs.append(str(num_towns))
        durations = [str(random.randint(1, 10 ** 9)) for _ in range(num_towns)]
        inputs.append(' '.join(durations))
    return '{}\n{}'.format(t, '\n'.join(inputs))

def batch_gen_inputs(batch_size,) -> list:
    batch_inputs = []
    for i in range(batch_size):
        batch_inputs.append(gen_input(i + 1, (i + 1) * 2))
    return batch_inputs
