import random


def gen_input(t: int, n: int, k: int, coords_and_time_range: tuple) -> str:
    assert 1 <= t <= 10 ** 4, 'Number of test cases out of range'
    assert 1 <= n <= 2 * 10 ** 5, 'Number of mines out of range'
    assert 0 <= k <= 10 ** 9, 'Distance that hit by mines during the explosion out of range'
    assert -10 ** 9 <= coords_and_time_range[0] <= 10 ** 9, 'Coordinates range out of range'
    assert 0 <= coords_and_time_range[1] <= 10 ** 9, 'Time range out of range'
    result = []
    result.append(str(t))
    for _ in range(t):
        result.append('')
        result.append(f'{n} {k}')
        for _ in range(n):
            x = random.randint(-coords_and_time_range[0], coords_and_time_range[0])
            y = random.randint(-coords_and_time_range[0], coords_and_time_range[0])
            timer = random.randint(0, coords_and_time_range[1])
            result.append(f'{x} {y} {timer}')
    return '\n'.join(result)

def batch_gen_inputs(batch_size,) -> list:
    inputs = []
    for _ in range(batch_size):
        t = random.randint(1, 10)
        n = random.randint(1, 5)
        k = random.randint(0, 10)
        coords_and_time_range = (10, 10)
        inputs.append(gen_input(t, n, k, coords_and_time_range))
    return inputs
