import random
import string


def gen_input(t: int, n: int) -> str:
    if not 1 <= t <= 1000:
        raise ValueError('t must be between 1 and 1000, inclusive.')
    if not 2 <= n <= 50:
        raise ValueError('n must be between 2 and 50, inclusive.')
    result = str(t) + '\n'
    for _ in range(t):
        s = ''.join((random.choice('EN') for _ in range(random.randint(2, n))))
        result += s + '\n'
    return result

def batch_gen_inputs(batch_size,):
    return [gen_input(5, 10) for _ in range(batch_size)]
