import random
import string


import random
from typing import Tuple, List


def gen_input(t: int, n_k_range: Tuple[int, int, int, int], x_max: int) -> str:
    (n_min, n_max, k_min, k_max) = n_k_range
    inputs = []
    for _ in range(t):
        n = random.randint(n_min, n_max)
        k = random.randint(k_min, k_max)
        x = random.randint(1, min(x_max, 10 ** 18))
        s = ''.join((random.choice('a*') for _ in range(n - 1))) + 'a'
        inputs.append(f'{n} {k} {x}\n{s}')
    return f'{t}\n' + '\n'.join(inputs) + '\n'

def batch_gen_inputs(batch_size,) -> List[str]:
    inputs = []
    for _ in range(batch_size):
        t = random.randint(1, 5)
        n_k_range = (1, random.randint(2, 5), 0, random.randint(1, 5))
        x_max = random.randint(1, 10 ** 3)
        inputs.append(gen_input(t, n_k_range, x_max))
    return inputs
