import random

def gen_input(t=10, max_len=10):
    """
    Generate a single test input.

    Parameters:
    - t (int): number of testcases.
    - max_len (int): maximum length of the sticks.

    Returns:
    - str: string representing the test input.
    """
    inputs = [str(t)]
    for _ in range(t):
        l_1 = random.randint(1, max_len)
        l_2 = random.randint(1, max_len)
        l_3 = random.randint(1, max_len)
        inputs.append(f'{l_1} {l_2} {l_3}')
    return '\n'.join(inputs)

def batch_gen_inputs(batch_size,t=10, max_len=10):
    """
    Generate a batch of test inputs.

    Parameters:
    - n (int): number of test inputs.
    - t (int): number of testcases for each input.
    - max_len (int): maximum length of the sticks for each input.

    Returns:
    - list[str]: list of strings representing the test inputs.
    """
    return [gen_input(t, max_len) for _ in range(batch_size)]
