# TEST_RESULT: False
from fractions import Fraction
from typing import List


def mod_inverse(a: int, m: int) -> int:
    return pow(a, m - 2, m)

def expected_time(n: int, m: int, r_b: int, c_b: int, r_d: int, c_d: int, p: int) -> int:
    max_steps = n * m * 4
    prob_clean = Fraction(p, 100)
    prob_not_clean = Fraction(100 - p, 100)
    (r, c) = (r_b, c_b)
    (dr, dc) = (1, 1)
    exp_time = Fraction(0)
    prob_not_clean_up_to_step = Fraction(1)
    for step in range(1, max_steps + 1):
        if r == r_d or c == c_d:
            exp_time += prob_not_clean_up_to_step * prob_clean * step
            prob_not_clean_up_to_step *= prob_not_clean
        r += dr
        c += dc
        if r == 1 or r == n:
            dr = -dr
        if c == 1 or c == m:
            dc = -dc
    (x, y) = (exp_time.numerator, exp_time.denominator)
    result = x * mod_inverse(y, MOD) % MOD
    return result

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    results = []
    for i in range(1, t + 1):
        (n, m, r_b, c_b, r_d, c_d, p) = map(int, lines[i].split())
        result = expected_time(n, m, r_b, c_b, r_d, c_d, p)
        results.append(str(result))
    return '\n'.join(results)
