# TEST_RESULT: True
from typing import List, Tuple

def dfs(room: int, target: int, visited: List[bool], path: List[int], tree: List[List[int]]) -> bool:
    if room == target:
        return True
    visited[room] = True
    for neighbor in tree[room]:
        if not visited[neighbor]:
            path.append(neighbor)
            if dfs(neighbor, target, visited, path, tree):
                return True
            path.pop()
    return False

def calculate_energy(path: List[int], illusion_rates: List[int]) -> int:
    energy = 0
    for i in range(1, len(path)):
        a_x = illusion_rates[path[i - 1]]
        a_y = illusion_rates[path[i]]
        energy += max(abs(a_x + a_y), abs(a_x - a_y))
    return energy

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    (n, q) = map(int, lines[0].split())
    illusion_rates = list(map(int, lines[1].split()))
    tree = [[] for _ in range(n)]
    for i in range(2, n + 1):
        (s, t) = map(int, lines[i].split())
        tree[s - 1].append(t - 1)
        tree[t - 1].append(s - 1)
    result = []
    for i in range(n + 1, n + q + 1):
        query = list(map(int, lines[i].split()))
        if query[0] == 1:
            (u, c) = (query[1], query[2])
            illusion_rates[u - 1] = c
        else:
            (u, v) = (query[1], query[2])
            visited = [False] * n
            path = [u - 1]
            dfs(u - 1, v - 1, visited, path, tree)
            energy = calculate_energy(path, illusion_rates)
            result.append(str(energy))
    return '\n'.join(result)
