import random
import numpy as np

def gen_input(n: int, m: int) -> str:
    input_str = f'{n} {m}\n'
    grid = np.zeros((n + 1, m + 1), dtype=int)
    pole_x = random.randint(0, n)
    pole_y = random.randint(0, m)
    grid[pole_x][pole_y] = 1
    for _ in range((n + 1) * (m + 1) // 10):
        x = random.randint(0, n)
        y = random.randint(0, m)
        grid[x][y] = 1
    for i in range(n + 1):
        for j in range(m + 1):
            input_str += str(grid[i][j])
        input_str += '\n'
    return input_str

def batch_gen_inputs(batch_size,) -> list:
    inputs = []
    for _ in range(batch_size):
        n = random.randint(0, 1999)
        m = random.randint(0, 1999)
        inputs.append(gen_input(n, m))
    return inputs
