# TEST_RESULT: True

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    (n, m) = map(int, lines[0].split())
    train_models = [list(map(int, lines[i + 1].split())) for i in range(n)]
    operations = [list(map(int, lines[i + n + 1].split())) for i in range(m)]
    trains = [None] * n
    trains_in_maintenance = []
    for i in range(m):
        (op, k) = operations[i]
        if op == 1:
            (x, y) = train_models[k - 1]
            trains[k - 1] = (i, x, y)
        else:
            trains[k - 1] = None
        maintenance_count = 0
        for j in range(n):
            train = trains[j]
            if train is not None:
                (day_added, x, y) = train
                cycle_length = x + y
                days_passed = i - day_added
                if days_passed % cycle_length >= x:
                    maintenance_count += 1
        trains_in_maintenance.append(maintenance_count)
    return '\n'.join(map(str, trains_in_maintenance))
