# TEST_RESULT: True
from itertools import combinations
from typing import List, Tuple


def calculate_diameter(graph: List[List[int]]) -> int:
    """
    Calculate the diameter of a graph represented as an adjacency list.
    """
    pass

def generate_graphs(n: int, m: int) -> List[List[List[int]]]:
    """
    Generate all possible graphs with n nodes and m edges.
    """
    pass

def is_possible_to_create_graph(n: int, m: int, k: int) -> str:
    """
    Check if it's possible to create a connected undirected graph with n nodes, m edges, and diameter < k-1.
    """
    min_diameter = 1
    max_diameter = min(n, m + 1)
    if min_diameter <= k - 1 < max_diameter and m >= n - 1:
        return 'YES'
    return 'NO'

def solution(stdin: str) -> str:
    inputs = stdin.strip().split('\n')
    t = int(inputs[0])
    test_cases = [tuple(map(int, line.split())) for line in inputs[1:]]
    results = []
    for (n, m, k) in test_cases:
        result = is_possible_to_create_graph(n, m, k)
        results.append(result)
    return '\n'.join(results)
