import random


def gen_input(args):
    colors = ['white', 'yellow', 'green', 'blue', 'red', 'orange']
    (k_min, k_max) = (1, min(args[0], 60))
    k = random.randint(k_min, k_max)
    (n_min, n_max) = (1, min(2 ** k - 1, args[1], 2000))
    n = random.randint(n_min, n_max)
    nodes = []
    for _ in range(n):
        v = random.randint(1, 2 ** k - 1)
        color = random.choice(colors)
        nodes.append(f'{v} {color}')
    return f'{k}\n{n}\n' + '\n'.join(nodes) + '\n'

def batch_gen_inputs(batch_size,):
    upper_limit = [5, 10]
    batch_inputs = [gen_input(upper_limit) for _ in range(batch_size)]
    return batch_inputs
