# TEST_RESULT: True

def solution(stdin: str) -> str:
    inputs = stdin.strip().split('\n')
    t = int(inputs[0])
    tests = []
    for i in range(t):
        n = int(inputs[i * 3 + 1])
        grid = [list(map(int, list(inputs[i * 3 + j + 2]))) for j in range(2)]
        tests.append((n, grid))
    dx = [-1, 0, 1]
    dy = [1, 1, 1]

    def dfs(x, y, n, grid, visited):
        if grid[x][y] == 1:
            return False
        if x == 1 and y == n - 1:
            return True
        visited[x][y] = True
        for i in range(3):
            (nx, ny) = (x + dx[i], y + dy[i])
            if 0 <= nx < 2 and 0 <= ny < n and (not visited[nx][ny]):
                if dfs(nx, ny, n, grid, visited):
                    return True
        return False
    results = []
    for (n, grid) in tests:
        visited = [[False] * n for _ in range(2)]
        if dfs(0, 0, n, grid, visited):
            results.append('YES')
        else:
            results.append('NO')
    return '\n'.join(results)
