import random

def gen_input(t: int, n_min: int, n_max: int) -> str:
    input_str = str(t) + '\n'
    for _ in range(t):
        n = random.randint(n_min, n_max)
        input_str += str(n) + '\n'
        for _ in range(2):
            level_str = ''.join((random.choice(['0', '1']) for _ in range(n)))
            if _ == 0:
                level_str = '0' + level_str[1:]
            else:
                level_str = level_str[:-1] + '0'
            input_str += level_str + '\n'
    return input_str

def batch_gen_inputs(batch_size,) -> list:
    inputs = []
    for _ in range(batch_size):
        t = random.randint(1, 10)
        n_min = random.randint(3, 7)
        n_max = random.randint(n_min, 10)
        inputs.append(gen_input(t, n_min, n_max))
    return inputs
