# TEST_RESULT: True
from typing import List, Tuple
from itertools import combinations

def count_valid_problemsets(problems: List[Tuple[int, int]]) -> int:
    count = 0
    for subset in combinations(problems, 3):
        topics = {problem[0] for problem in subset}
        difficulties = {problem[1] for problem in subset}
        if len(topics) == 3 or len(difficulties) == 3:
            count += 1
    return count

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    index = 1
    result = []
    for _ in range(t):
        n = int(lines[index])
        index += 1
        problems = []
        for _ in range(n):
            (a, b) = map(int, lines[index].split())
            index += 1
            problems.append((a, b))
        result.append(count_valid_problemsets(problems))
    return '\n'.join(map(str, result))
