# TEST_RESULT: True
from typing import List, Tuple
import math
import itertools

def distance(p1: Tuple[int, int], p2: Tuple[int, int]) -> float:
    return math.sqrt((p2[0] - p1[0]) ** 2 + (p2[1] - p1[1]) ** 2)

def brute_force_path_length(start: int, points: List[Tuple[int, int]]) -> float:
    min_length = float('inf')
    for perm in itertools.permutations(points):
        total_length = distance(points[start - 1], perm[0])
        for i in range(1, len(perm)):
            total_length += distance(perm[i - 1], perm[i])
        min_length = min(min_length, total_length)
    return min_length

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    (N, K) = map(int, lines[0].split())
    points = [tuple(map(int, line.split())) for line in lines[1:]]
    min_length = brute_force_path_length(K, points)
    return str(min_length)
