import random


def gen_input(n: int, a_min: int, a_max: int) -> str:
    assert 1 <= n <= 2 * 10 ** 5
    assert 0 <= a_min <= 10 ** 9
    assert a_min <= a_max <= 10 ** 9
    A = [random.randint(a_min, a_max) for _ in range(n)]
    input_str = str(n) + '\n' + ' '.join(map(str, A)) + '\n'
    return input_str

def batch_gen_inputs(batch_size,) -> list:
    input_strings = []
    for _ in range(batch_size):
        n = random.randint(1, 10)
        a_min = random.randint(0, 10)
        a_max = random.randint(a_min, 20)
        input_strings.append(gen_input(n, a_min, a_max))
    return input_strings
