import random


def gen_input(n_limit: int, q_limit: int, k_limit: int) -> str:
    n = random.randint(1, n_limit)
    q = random.randint(1, q_limit)
    k = random.randint(1, min(n, k_limit))
    ticket_costs = [random.randint(1, 10 ** 9) for _ in range(n)]
    segments = [(random.randint(1, n), random.randint(1, n)) for _ in range(q)]
    segments = [(min(l, r), max(l, r)) for (l, r) in segments]
    input_str = f'{n} {q} {k}\n'
    input_str += ' '.join(map(str, ticket_costs)) + '\n'
    for (l, r) in segments:
        input_str += f'{l} {r}\n'
    return input_str

def batch_gen_inputs(batch_size,) -> list:
    test_inputs = []
    for _ in range(batch_size):
        test_inputs.append(gen_input(10, 5, 5))
    return test_inputs
