# TEST_RESULT: True

def solution(stdin: str) -> str:
    tests = stdin.strip().split('\n\n')
    num_tests = int(tests.pop(0))
    result = []
    for test in tests:
        lines = test.split('\n')
        (n, m) = map(int, lines.pop(0).split())
        grid = [list(line) for line in lines]
        max_steps = 0
        max_cell = None
        for i in range(n):
            for j in range(m):
                steps = 0
                visited = set()
                (x, y) = (i, j)
                while 0 <= x < n and 0 <= y < m and ((x, y) not in visited):
                    visited.add((x, y))
                    steps += 1
                    if grid[x][y] == 'L':
                        y -= 1
                    elif grid[x][y] == 'R':
                        y += 1
                    elif grid[x][y] == 'U':
                        x -= 1
                    elif grid[x][y] == 'D':
                        x += 1
                if steps > max_steps:
                    max_steps = steps
                    max_cell = (i + 1, j + 1)
        result.append(f'{max_cell[0]} {max_cell[1]} {max_steps}')
    return '\n'.join(result)
