# TEST_RESULT: True
from itertools import permutations

def count_local_extrema(p):
    maxima = 0
    minima = 0
    for i in range(1, len(p) - 1):
        if p[i - 1] < p[i] > p[i + 1]:
            maxima += 1
        if p[i - 1] > p[i] < p[i + 1]:
            minima += 1
    return (maxima, minima)

def solve(n, a, b):
    for p in permutations(range(1, n + 1)):
        (maxima, minima) = count_local_extrema(p)
        if maxima == a and minima == b:
            return p
    return -1

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    results = []
    for i in range(1, t + 1):
        (n, a, b) = map(int, lines[i].split())
        result = solve(n, a, b)
        if result == -1:
            results.append('-1')
        else:
            results.append(' '.join((str(x) for x in result)))
    return '\n'.join(results)
