# TEST_RESULT: True


def valid_coloring(dominoes):
    n = len(dominoes)
    for i in range(n):
        if dominoes[i][1] == dominoes[(i + 1) % n][0]:
            return False
    return True

def generate_colorings(dominoes, i=0):
    if i == len(dominoes):
        return [dominoes]
    else:
        colorings = []
        for color in ['B', 'W']:
            new_dominoes = dominoes.copy()
            new_dominoes[i] = (new_dominoes[i][0], color) if new_dominoes[i][1] == '?' else (color, new_dominoes[i][1])
            colorings.extend(generate_colorings(new_dominoes, i + 1))
        return colorings

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    n = int(lines[0])
    dominoes = []
    for line in lines[1:]:
        dominoes.append(tuple(line))
    colorings = generate_colorings(dominoes)
    count = sum((1 for coloring in colorings if valid_coloring(coloring)))
    return str(count % 998244353)
