import random
import string


def gen_input(n_nodes=10, n_strings=5, n_queries=3):
    assert 2 <= n_nodes <= 10 ** 5
    assert 1 <= n_strings, n_queries <= 10 ** 5
    edges = []
    for i in range(2, n_nodes + 1):
        parent = random.randint(1, i - 1)
        char = random.choice(string.ascii_lowercase)
        edges.append(f'{parent} {i} {char}')
    strings = []
    total_length = 0
    for _ in range(n_strings):
        if total_length < 10 ** 5:
            length = random.randint(1, min(10 ** 5 - total_length, 100))
            total_length += length
            s = ''.join(random.choices(string.ascii_lowercase, k=length))
            strings.append(s)
    queries = []
    for _ in range(n_queries):
        start = random.randint(1, n_nodes)
        end = random.choice([i for i in range(1, n_nodes + 1) if i != start])
        left = random.randint(1, n_strings)
        right = random.randint(left, n_strings)
        queries.append(f'{start} {end} {left} {right}')
    input_str = f'{n_nodes} {n_strings} {n_queries}\n'
    input_str += '\n'.join(edges) + '\n'
    input_str += '\n'.join(strings) + '\n'
    input_str += '\n'.join(queries)
    return input_str

def batch_gen_inputs(batch_size,):
    return [gen_input() for _ in range(batch_size)]
