# TEST_RESULT: True
from itertools import product


def calc_value(array):
    """Calculates the value of an array"""
    return len(set((array[i] for i in range(len(array) - 1) if array[i] == array[i + 1])))

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    n = int(lines[0])
    array = list(map(int, lines[1].split()))
    zero_positions = [i for (i, x) in enumerate(array) if x == 0]
    max_value = -1
    max_array = []
    for replacements in product(range(1, n + 1), repeat=len(zero_positions)):
        new_array = array.copy()
        for (pos, rep) in zip(zero_positions, replacements):
            new_array[pos] = rep
        value = calc_value(new_array)
        if value > max_value:
            max_value = value
            max_array = new_array
    return ' '.join(map(str, max_array)) + '\n'
