# TEST_RESULT: False
from typing import List, Tuple

def count_exchanges(x_val: int, y_val: int) -> int:
    count = 0
    while x_val != y_val:
        k = 0
        while 2 ** k < x_val:
            k += 1
        x_val = 2 ** k - x_val
        count += 1
    return count

def brute_force_chocolate_exchange(n: int, chocolates: List[int]) -> Tuple[int, int, int]:
    max_exchanges = 0
    (max_x, max_y) = (0, 0)
    for x in range(n):
        for y in range(n):
            if x != y:
                
                exchanges = count_exchanges(chocolates[x], chocolates[y])
                if exchanges > max_exchanges:
                    max_exchanges = exchanges
                    (max_x, max_y) = (x, y)
    return (max_x + 1, max_y + 1, max_exchanges)

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    n = int(lines[0])
    chocolates = list(map(int, lines[1].split()))
    (x, y, m) = brute_force_chocolate_exchange(n, chocolates)
    return f'{x} {y} {m}'