import random
from itertools import combinations


def gen_input(min_val: int, max_val: int, t: int) -> str:
    result = str(t) + '\n'
    for _ in range(t):
        a = sorted(random.sample(range(min_val, max_val + 1), 3))
        b = sorted((sum(comb) for r in range(1, len(a) + 1) for comb in combinations(a, r)))
        result += ' '.join(map(str, b)) + '\n'
    return result

def batch_gen_inputs(batch_size,):
    inputs = []
    min_vals = [1, 10, 100, 200, 300, 500]
    max_vals = [10, 20, 100, 200, 300, 500]
    for _ in range(batch_size):
        min_val = random.choice(min_vals)
        max_val = random.choice(max_vals)
        if min_val > max_val:
            min_val, max_val = max_val, min_val
        inputs.append(gen_input(min_val, max_val, 5))
    return inputs
