# TEST_RESULT: False
from itertools import permutations
from typing import List, Tuple


def explode_all_mines(n: int, k: int, mines: List[Tuple[int, int, int]]) -> int:
    exploded = set()
    seconds = 0
    for i in range(n):
        seconds += 1
        (x, y, timer) = mines[i]
        exploded.add((x, y))
        for j in range(n):
            if j == i:
                continue
            (x_j, y_j, timer_j) = mines[j]
            if abs(x - x_j) <= k and y == y_j:
                exploded.add((x_j, y_j))
            elif abs(y - y_j) <= k and x == x_j:
                exploded.add((x_j, y_j))
        if len(exploded) == n:
            break
    return seconds

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    results = []
    i = 1
    for _ in range(t):
        (n, k) = map(int, lines[i + 1].split())
        mines = [tuple(map(int, lines[j].split())) for j in range(i + 2, i + 2 + n)]
        i += n + 2
        min_seconds = float('inf')
        for order in permutations(mines):
            seconds = explode_all_mines(n, k, order)
            min_seconds = min(min_seconds, seconds)
        results.append(str(min_seconds))
    return '\n'.join(results)
