import random


def gen_input(t_max: int, wh_max: int, k_max: int):
    t = random.randint(1, t_max)
    input_string = str(t) + '\n'
    for _ in range(t):
        w = random.randint(3, wh_max)
        h = random.randint(3, wh_max)
        input_string += str(w) + ' ' + str(h) + '\n'
        for _ in range(2):
            k = random.randint(2, min(k_max, w - 1))
            points = sorted(random.sample(range(1, w), k))
            input_string += str(k) + ' ' + ' '.join(map(str, points)) + '\n'
        for _ in range(2):
            k = random.randint(2, min(k_max, h - 1))
            points = sorted(random.sample(range(1, h), k))
            input_string += str(k) + ' ' + ' '.join(map(str, points)) + '\n'
    return input_string

def batch_gen_inputs(batch_size,):
    batch_inputs = []
    for _ in range(batch_size):
        input_string = gen_input(2, 10, 4)
        batch_inputs.append(input_string)
    return batch_inputs
