# TEST_RESULT: False
from itertools import product


def generate_ba_strings(s, k):
    """
    Generate all possible BA-strings by replacing asterisks in the input string s with 0 to k inclusive 'b's.
    """
    asterisk_positions = [i for (i, c) in enumerate(s) if c == '*']
    replacement_counts = product(range(k + 1), repeat=len(asterisk_positions))
    ba_strings = []
    for counts in replacement_counts:
        new_string = list(s)
        for (i, count) in enumerate(counts):
            new_string[asterisk_positions[i]] = 'b' * count
        ba_strings.append(''.join(new_string))
    return ba_strings

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    testcases = []
    for i in range(1, len(lines), 2):
        (n, k, x) = map(int, lines[i].split())
        s = lines[i + 1]
        testcases.append((n, k, x, s))
    output = []
    for (n, k, x, s) in testcases:
        ba_strings = generate_ba_strings(s, k)
        ba_strings.sort()
        output.append(ba_strings[x - 1])
    return '\n'.join(output)