import random


def gen_input(n: int, m: int) -> str:
    q = random.randint(1, n)
    queries = []
    for _ in range(q):
        query_type = random.randint(1, 2)
        if query_type == 1:
            x = random.randint(1, m)
            queries.append(f'1 {x}')
        else:
            (x, y) = random.sample(range(1, m + 1), 2)
            queries.append(f'2 {x} {y}')
    return f'{q}\n' + '\n'.join(queries)

def batch_gen_inputs(batch_size,) -> list[str]:
    inputs = [gen_input(10, 10) for _ in range(batch_size)]
    return inputs
