# TEST_RESULT: True
from typing import List, Tuple

def is_bipartite(a: List[int]) -> bool:
    n = len(a)
    graph = [[] for _ in range(n)]
    for i in range(n):
        for j in range(i + 1, n):
            if a[i] > a[j]:
                graph[i].append(j)
                graph[j].append(i)
    color = [0] * n

    def dfs(v: int, c: int) -> bool:
        color[v] = c
        for u in graph[v]:
            if color[u] == c:
                return False
            if color[u] == 0 and (not dfs(u, 3 - c)):
                return False
        return True
    for i in range(n):
        if color[i] == 0 and (not dfs(i, 1)):
            return False
    return True

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    output = []
    index = 1
    for _ in range(t):
        n = int(lines[index])
        p = list(map(int, lines[index + 1].split()))
        found = False
        for signs in range(1 << n):
            a = [p[i] if signs & 1 << i else -p[i] for i in range(n)]
            if is_bipartite(a):
                output.append('YES')
                output.append(' '.join(map(str, a)))
                found = True
                break
        if not found:
            output.append('NO')
        index += 2
    return '\n'.join(output)
