# TEST_RESULT: True
from itertools import permutations


def calculate_sum_of_absolute_differences(p, q):
    return sum((abs(p[i] - q[i]) for i in range(len(p))))

def is_valid_permutation(q, s):
    max_disliked = 0
    for i in range(len(q)):
        if s[i] == '0':
            max_disliked = max(max_disliked, q[i])
        elif q[i] <= max_disliked:
            return False
    return True

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    output = []
    index = 1
    for _ in range(t):
        n = int(lines[index])
        p = list(map(int, lines[index + 1].split()))
        s = lines[index + 2]
        index += 3
        min_sum_of_differences = float('inf')
        best_permutation = None
        for q in permutations(range(1, n + 1)):
            if is_valid_permutation(q, s):
                sum_of_differences = calculate_sum_of_absolute_differences(p, q)
                if sum_of_differences < min_sum_of_differences:
                    min_sum_of_differences = sum_of_differences
                    best_permutation = q
        output.append(' '.join(map(str, best_permutation)))
    return '\n'.join(output)

def is_valid_output(p, q, s):
    if sorted(q) != list(range(1, len(q) + 1)):
        return False
    if not is_valid_permutation(q, s):
        return False
    return True
