# TEST_RESULT: True
from math import factorial, isqrt
from typing import List, Tuple

def generate_subsets(subset: List[int], i: int, n: int) -> List[List[int]]:
    if i > n:
        return [subset]
    return generate_subsets(subset, i + 1, n) + generate_subsets(subset + [i], i + 1, n)

def is_square(num: int) -> bool:
    root = isqrt(num)
    return root * root == num

def get_max_quadratic_subset(n: int) -> Tuple[int, List[int]]:
    max_subset = []
    subsets = generate_subsets([], 1, n)
    for subset in subsets:
        product = 1
        for elem in subset:
            product *= factorial(elem)
        if is_square(product) and len(subset) > len(max_subset):
            max_subset = subset
    return (len(max_subset), max_subset)

def solution(stdin: str) -> str:
    n = int(stdin.strip())
    (max_size, max_subset) = get_max_quadratic_subset(n)
    return str(max_size) + '\n' + ' '.join(map(str, max_subset)) + '\n'
