
#### Install requirements
munkres
tensorboard
opencv-python
wandb
prettytable
timm

The datasets used can be downloaded from official websites.

#### Training Commands
The config files are in `config/`,which is the demo of DCBoost based on ProPos, just run the following command:
```shell
export CUDA_VISIBLE_DEVICES=0,1,2,3 # use the first 4 GPUs
torchrun --master_port 17685 --nproc_per_node=4 main.py config/cifar10_r34_dcboost.yml
```
-As for CIFAR-10, to skip the baseline training and directly resume DCBoost, we provide the ProPos checkpoints in \[[Google Drive](https://drive.google.com/file/d/1QKSu-Y2nkjRWtbssR1N_K8gBIvjHNCMk/view?usp=drive_link)\]:

1) save the checkpoints into the folder `ckpt/your_run_name/save_models/`

2) modify the corresponding variables `resume_name` and `resume_epoch`, and run the code above.
  
3) The final checkpoints are saved in \[[Google Drive](https://drive.google.com/file/d/1wdd4lBzTTXUk96iFYstvcQk5e6WRhGj8/view?usp=drive_link)\].


## : Acknowledgement
Our code framework is based on [ProPos](https://github.com/Hzzone/ProPos)



