# A hard-to-beat baseline for training-free CLIP-based adaptation
Official implementation of A hard-to-beat baseline for training-free CLIP-based adaptation. 

## Requirements
### Installation
Create a conda environment and install dependencies:
```
conda create -n h2b python=3.9
conda activate h2b

pip install -r requirements.txt

# Install the according versions of torch and torchvision
conda install pytorch torchvision cudatoolkit
```

### Dataset
Follow DATASET.md to install ImageNet and other datasets referring to CoOp.

## Get Started
### Configs
The running configurations can be modified in `configs/setting/dataset.yaml`, including evaluation setting, shot numbers, visual encoders, and hyperparamters. 

### Numerical Results
We provide  **numerical results** in few-shot classification in figure 1 at exp.log.

### Running
For few-shot classification:
```bash
CUDA_VISIBLE_DEVICES=0 python main_few_shots.py --config configs/few_shots/dataset.yaml
```
For base-to-new generalization:
```bash
CUDA_VISIBLE_DEVICES=0 python main_base2new.py --config configs/base2new/dataset.yaml
```