
# Highlight Diffusion: Training-Free Attention-Guided Acceleration for Text-to-Image Models

This repository contains the code and instructions to reproduce the results presented in the paper: 
**Highlight Diffusion: Training-Free Attention-Guided Acceleration for Text-to-Image Models**.

## Table of Contents
- [Installation](#installation)
- [File Downloads](#file-downloads)
- [Reproducing Results](#reproducing-results)
- [Citing](#citing)

## Installation

To set up the environment needed to run the code, you can use Conda. Make sure you have [Anaconda](https://docs.anaconda.com/anaconda/install/) installed before proceeding.

To create the environment, run the following commands:
```bash
conda env create -f environment.yml
conda activate hldiff
```

This will create a new conda environment named `hldiff` and install all the necessary dependencies.

## File Downloads

Before running the experiments, you need to download additional files required for generation. Run the following script to download the necessary resources:
```bash
bash scripts/download_files.sh
```

This will download the vanilla pre-trained stable diffusion model (v1.4) and nltk tokenizer required for running our highlight-diffusion pipeline.

## Reproducing Results

To reproduce the image generation on the COCO dataset, follow these steps:

1. Ensure you have activated the conda environment (`conda activate hldiff`).
2. Use the following command to run the generation task:
```bash
python run.py --prompt prompts_coco2014.json --config_path configs/highlight.yaml --output_path samples/coco --interval 5 --mask_threshold 100
```

- `--prompt prompts_coco2014.json`: Points to the file containing prompts from the COCO dataset.
- `--config_path configs/highlight.yaml`: Specifies the path to the configuration file.
- `--output_path samples/coco`: The output directory where the generated samples will be stored.
- `--interval 5`: Sets the interval for full recomputation. Setting interval=1 will generate using the original pipeline without computing masks.
- `--mask_threshold 100`: Defines the threshold for the binary mask during the partial computation process.

You could also pass any texts you would like to the "--prompt" option, for example 
```bash
python run.py --prompt "A girl holding a cat" --config_path configs/highlight.yaml --output_path samples --interval 5 --mask_threshold 100
```
